import operator
from config.model_config import ContextTextEncoderConfig
from config.model_config import ContextImageEncoderConfig


class ContextEncoderConfig:
    input_size = operator.add(ContextTextEncoderConfig.text_feat_size,
                              ContextImageEncoderConfig.image_feat_size)
    num_head = 1
    dim_feedforward = 1024
    dropout = 0.1
    activation = 'gelu'
    num_layers = 1
    embed_size = 1024
    output_size = dim_feedforward * num_layers
    max_len = 512
    # hidden_size = 1024
    # num_layers = 1
    # num_directions = 2
    # embed_size = 512
    # output_size = hidden_size * num_layers * num_directions
